---@type l10n
local l10n = QuestieLoader:ImportModule("l10n")

local generalOptionsLocales = {
    ["General"] = {
        ["ptBR"] = "Opções",
        ["ruRU"] = "Общее",
        ["deDE"] = "Allgemein",
        ["koKR"] = "일반",
        ["esMX"] = "Opciones",
        ["enUS"] = true,
        ["zhCN"] = "一般",
        ["zhTW"] = "一般",
        ["esES"] = "Opciones",
        ["frFR"] = "Options",
    },
    ["General Options"] = {
        ["ptBR"] = "Opções Generais",
        ["ruRU"] = "Общие настройки",
        ["deDE"] = "Allgemeine Einstellungen",
        ["koKR"] = "일반 설정",
        ["esMX"] = "Opciones de Questie",
        ["enUS"] = true,
        ["zhCN"] = "一般选项",
        ["zhTW"] = "一般選項",
        ["esES"] = "Opciones de Questie",
        ["frFR"] = "Options générales",
    },
    ["Enable Icons"] = {
        ["ptBR"] = "Ativar os ícones",
        ["ruRU"] = "Значки Questie",
        ["deDE"] = "Icons aktivieren",
        ["koKR"] = "아이콘 활성화",
        ["esMX"] = "Habilitar Iconos",
        ["enUS"] = true,
        ["zhCN"] = "图标",
        ["zhTW"] = "圖示",
        ["esES"] = "Habilitar Iconos",
        ["frFR"] = "Activer les icônes",
    },
    ["Enable or disable Questie icons."] = {
        ["ptBR"] = "Ativar ou desativar os ícones da Questie",
        ["ruRU"] = "Показать/скрыть значки Questie",
        ["deDE"] = "Aktivieren/Deaktivieren der Questie-Icons",
        ["koKR"] = "Questie 아이콘을 활성화합니다.",
        ["esMX"] = "Habilitar iconos de Questie",
        ["enUS"] = true,
        ["zhCN"] = "启用或禁用Questie图标",
        ["zhTW"] = "啟用/停用Questie圖示",
        ["esES"] = "Habilitar iconos de Questie",
        ["frFR"] = "Active les icônes de Questie",
    },
    ["Config Tracking Icons"] = {
        ["ptBR"] = "Configurar ícones de rastreamento",
        ["ruRU"] = "Отслеживаемые значки",
        ["deDE"] = "Tracking Icons konfigurieren",
        ["koKR"] = "추적 아이콘 설정",
        ["esMX"] = "Configurar iconos de seguimiento",
        ["enUS"] = true,
        ["zhCN"] = "设置追踪图标",
        ["zhTW"] = "設定追蹤圖示",
        ["esES"] = "Configurar iconos de seguimiento",
        ["frFR"] = "Configurer les icônes de suivi",
    },
    ["Allows to select which the tracking icons (like Mailbox, Repair-NPCs) to show on the map and minimap."] = {
        ["ptBR"] = "Permite selecionar quais ícones de rastreamento (como Caixa de Correio, PNJ de Reparo) mostrar no mapa e minimapa.",
        ["ruRU"] = "Позволяет выбрать, какие отслеживаемые значки (почтовый ящик, ремонт и проч.) отображать на карте и миникарте",
        ["deDE"] = "Ermöglicht das Konfigurieren der Tracking Icons (z.B. Briefkästen, Reparatur-NPCs) auf der Karte und Minimap.",
        ["koKR"] = "지도에 표시할 추적 아이콘(예: 우체통, 수리NPC)을 선택할 수 있습니다.",
        ["esMX"] = "Permite seleccionar qué iconos de seguimiento (como Buzón, PNJ de Reparación) se mostrarán en el mapa y el minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "允许在地图和小地图上显示选择的NPC图标（例如“邮箱”，“修理”）。",
        ["zhTW"] = "允許在地圖和小地圖上顯示選擇的 NPC 圖示（例如郵箱、修理 NPC）",
        ["esES"] = "Permite seleccionar qué iconos de seguimiento (como Buzón, PNJ de Reparación) se mostrarán en el mapa y el minimapa.",
        ["frFR"] = "Permet de sélectionner les icônes de suivi (comme la boîte aux lettres, les PNJ de réparation) à afficher sur la carte et la mini-carte.",
    },
    ["Icon Types"] = {
        ["ptBR"] = "Tipos de ícones",
        ["ruRU"] = "Типы значков",
        ["deDE"] = "Icon-Arten",
        ["koKR"] = "아이콘 유형",
        ["esMX"] = "Tipos de icono",
        ["enUS"] = true,
        ["zhCN"] = "图标类别",
        ["zhTW"] = "圖示類別",
        ["esES"] = "Tipos de icono",
        ["frFR"] = "Types d'icônes",
    },
    ["When this is enabled, the quest turn-in locations will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando ativado, os locais de ativação da missão serão exibidos no mapa / mapa mínimo",
        ["ruRU"] = "Показать/скрыть местоположения выполненных заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der abgeschlossenen Quests auf der Karte/Minimap.",
        ["koKR"] = "퀘스트 완료 아이콘을 지도와 미니맵에 표시합니다.",
        ["esMX"] = "Cuando está habilitado los iconos de misión completada apareceran en el mapa y minimapa",
        ["enUS"] = true,
        ["zhCN"] = "若启用，在地图上标记提交任务的地点",
        ["zhTW"] = "在地圖上標記回報任務的地點",
        ["esES"] = "Cuando está habilitado los iconos de misión completada apareceran en el mapa y minimapa",
        ["frFR"] = "Active l'affichage des lieux où rendre les quêtes sur la carte/mini-carte.",
    },
    ["Enable Map Icons"] = {
        ["ptBR"] = "Ativar ícones do mapa",
        ["ruRU"] = "Значки на карте мира",
        ["deDE"] = "Karten-Icons anzeigen",
        ["koKR"] = "지도 아이콘 활성화",
        ["esMX"] = "Habilitar iconos en el mapa",
        ["enUS"] = true,
        ["zhCN"] = "启用大地图图标",
        ["zhTW"] = "大地圖圖示",
        ["esES"] = "Habilitar iconos en el mapa",
        ["frFR"] = "Activer les icônes sur la carte",
    },
    ["Show/hide all icons from the main map."] = {
        ["ptBR"] = "Mostrar / ocultar todos os ícones na carta principal",
        ["ruRU"] = "Показать/скрыть все значки на карте мира",
        ["deDE"] = "Aktiviert/Deaktiviert alle Icons auf der Karte",
        ["koKR"] = "세계 지도에 퀘스트 아이콘을 표시합니다.",
        ["esMX"] = "Mostrar/Esconder todos los iconos del mapa principal",
        ["enUS"] = true,
        ["zhCN"] = "启用或停用大地图上的所有图标",
        ["zhTW"] = "在大地圖上顯示所有的圖示",
        ["esES"] = "Mostrar/Esconder todos los iconos del mapa principal",
        ["frFR"] = "Active l'affichage de toutes les icônes sur la carte.",
    },
    ["Enable Minimap Icons"] = {
        ["ptBR"] = "Ativar ícones do Mini-mapa",
        ["ruRU"] = "Значки на миникарте",
        ["deDE"] = "Minimap-Icons anzeigen",
        ["koKR"] = "미니맵 아이콘 활성화",
        ["esMX"] = "Habilitar iconos del minimapa",
        ["enUS"] = true,
        ["zhCN"] = "启用小地图标记",
        ["zhTW"] = "小地圖圖示",
        ["esES"] = "Habilitar iconos del minimapa",
        ["frFR"] = "Activer les icônes sur la mini-carte",
    },
    ["Show/hide all icons from the minimap."] = {
        ["ptBR"] = "Mostrar / ocultar todos os ícones no mini-mapa",
        ["ruRU"] = "Показать/скрыть все значки на миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert alle Icons auf der Minimap",
        ["koKR"] = "미니맵에 퀘스트 아이콘을 표시합니다.",
        ["esMX"] = "Mostrar/Esconder todos los iconos del minimapa",
        ["enUS"] = true,
        ["zhCN"] = "启用或停用小地图上的所有图标",
        ["zhTW"] = "在小地圖上顯示圖示",
        ["esES"] = "Mostrar/Esconder todos los iconos del minimapa",
        ["frFR"] = "Active l'affichage de toutes les icônes sur la mini-carte.",
    },
    ["Hide unexplored area Icons"] = {
        ["ptBR"] = "Ocultar ícones da área inexplorada",
        ["ruRU"] = "Скрыть значки неисследованных зон",
        ["deDE"] = "Icons in nicht entdeckten Gebieten verbergen",
        ["koKR"] = "미탐험 지역 아이콘 가리기",
        ["esMX"] = "Esconder icono de áreas inexploradas.",
        ["enUS"] = true,
        ["zhCN"] = "隐藏未探测区域图标",
        ["zhTW"] = "隱藏未探索區域圖示",
        ["esES"] = "Esconder icono de áreas inexploradas.",
        ["frFR"] = "Cacher les icônes des zones inexplorées",
    },
    ["Hide icons in unexplored areas."] = {
        ["ptBR"] = "Oculta ícones em áreas inexploradas.",
        ["ruRU"] = "Скрывает значки в неисследованных областях карты",
        ["deDE"] = "Verbirgt die Questie Icons in nicht entdeckten Gebieten.",
        ["koKR"] = "미탐험 지역의 아이콘을 가립니다.",
        ["esMX"] = "Esconder iconos en áreas inexploradas.",
        ["enUS"] = true,
        ["zhCN"] = "隐藏未探测区域中的图标",
        ["zhTW"] = "在未探索的區域不顯示圖示",
        ["esES"] = "Esconder iconos en áreas inexploradas.",
        ["frFR"] = "Désactive l'affichage des icônes dans les zones inexplorées.",
    },
    ["Hide icons of untracked quests"] = {
        ["ptBR"] = false,
        ["ruRU"] = "Скрыть значки неотслеживаемых заданий",
        ["deDE"] = "Icons nicht getrackter Quests verbergen",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = false,
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Hide icons for quests that are not tracked."] = {
        ["ptBR"] = false,
        ["ruRU"] = "Скрывает значки заданий, которые не отслеживаются в трекере",
        ["deDE"] = "Verbirgt die Icons aller Quests die nicht vom Tracker getrackt werden.",
        ["koKR"] = false,
        ["esMX"] = false,
        ["enUS"] = true,
        ["zhCN"] = false,
        ["zhTW"] = false,
        ["esES"] = false,
        ["frFR"] = false,
    },
    ["Enable Available Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões disponíveis",
        ["ruRU"] = "Значки доступных заданий",
        ["deDE"] = "Icons zu verfügbaren Quests anzeigen",
        ["koKR"] = "수행 가능한 퀘스트 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misión disponible",
        ["enUS"] = true,
        ["zhCN"] = "启用可接任务图标",
        ["zhTW"] = "可取得的任務標記",
        ["esES"] = "Habilitar iconos de misión disponible",
        ["frFR"] = "Icônes des quêtes disponibles",
    },
    ["When this is enabled, the locations of available quest will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando esta opção está ativada, os locais de ativação da missão serão exibidos no mapa / mini mapa",
        ["ruRU"] = "Показать/скрыть местоположения доступных заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der verfügbaren Quests auf der Karte/Minimap.",
        ["koKR"] = "수행 가능한 퀘스트 아이콘을 지도와 미니맵에 표시합니다.",
        ["esMX"] = "Cuando está habilitado los iconos de misión disponible apareceran en el mapa y minimapa",
        ["enUS"] = true,
        ["zhCN"] = "若启用，在地图上标记可接任务的地点",
        ["zhTW"] = "在地圖上標記可取得任務的地點",
        ["esES"] = "Cuando está habilitado los iconos de misión disponible apareceran en el mapa y minimapa",
        ["frFR"] = "Active l'affichage des lieux où prendre les quêtes sur la carte/mini-carte.",
    },
    ["Enable Event Quest Icons"] = {
        ["ptBR"] = "Ativar ícones da missão de eventos",
        ["ruRU"] = "Значки заданий игровых событий",
        ["deDE"] = "Event-Quest anzeigen",
        ["koKR"] = "이벤트 퀘스트 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misiones de eventos",
        ["enUS"] = true,
        ["zhCN"] = "启用事件任务图标",
        ["zhTW"] = "事件任務圖示",
        ["esES"] = "Habilitar iconos de misiones de eventos",
        ["frFR"] = "Icônes des quêtes d'évènement",
    },
    ["When this is enabled, the locations of events quest will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando isso estiver ativado, a busca de locais de eventos será mostrada no mapa/minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения заданий игровых событий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von Event-Quests auf der Karte/Minimap.",
        ["koKR"] = "아이콘을 활성화시, 이벤트 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["esMX"] = "Si está marcado, la localización de misiones de eventos mostrará en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，事件任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "在世界地圖/小地圖上顯示可取得事件任務的地點",
        ["esES"] = "Si está marcado, la localización de misiones de eventos mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes des évènements mondiaux sur la carte/mini-carte.",
    },
    ["Enable Objective Icons"] = {
        ["ptBR"] = "Ativar ícones do objectivo",
        ["ruRU"] = "Значки целей заданий",
        ["deDE"] = "Icons zu Questzielen anzeigen",
        ["koKR"] = "퀘스트 목표 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de objetivo",
        ["enUS"] = true,
        ["zhCN"] = "启用互动目标图标",
        ["zhTW"] = "互動目標圖示",
        ["esES"] = "Habilitar iconos de objetivo",
        ["frFR"] = "Icônes des objectifs",
    },
    ["When this is enabled, quest objective icons will be shown on the map/minimap."] = {
        ["ptBR"] = "Se ativado, os ícones do objectivo da missão serão exibidos no mapa / mini-carta",
        ["ruRU"] = "Показать/скрыть значки целей заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der Questziele auf der Karte/Minimap.",
        ["koKR"] = "퀘스트 목표 아이콘을 지도와 미니맵에 표시합니다.",
        ["esMX"] = "Cuando está habilitado los iconos de objetivo apareceran en el mapa y minimapa",
        ["enUS"] = true,
        ["zhCN"] = "若启用，在地图上显示任务互动目标",
        ["zhTW"] = "在地圖上顯示任務互動目標",
        ["esES"] = "Cuando está habilitado los iconos de objetivo apareceran en el mapa y minimapa",
        ["frFR"] = "Active l'affichage des icônes des objectifs de quête sur la carte/mini-carte.",
    },
    ["Enable Repeatable Quest Icons"] = {
        ["ptBR"] = "Mostrar missões repetíveis no mapa",
        ["ruRU"] = "Значки повторяемых заданий",
        ["deDE"] = "Wiederholbare Quests anzeigen",
        ["koKR"] = "지도에 반복 퀘스트를 표시",
        ["esMX"] = "Mostrar misiones repetibles",
        ["enUS"] = true,
        ["zhCN"] = "启用重复的任务图标",
        ["zhTW"] = "重複的任務圖示",
        ["esES"] = "Mostrar misiones repetibles",
        ["frFR"] = "Quêtes répétables sur la carte",
    },
    ["When this is enabled, the locations of repeatable quest will be shown on the map/minimap."] = {
        ["ptBR"] = "Escolha se missões repetíveis devem estar visíveis no mapa e no minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения повторяемых заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von wiederholbaren Quests auf der Karte/Minimap.",
        ["koKR"] = "지도나 미니맵에 반복 퀘스트를 표시할지 말지 선택합니다.",
        ["esMX"] = "Muestra las misiones repetibles en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，重复任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "在世界地圖/小地圖上顯示可取得重複任務的地點",
        ["esES"] = "Muestra las misiones repetibles en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes répétables sur la carte et la mini-carte.",
    },
    ["Enable Raid Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões de raide",
        ["ruRU"] = "Значки рейдовых заданий",
        ["deDE"] = "Raid-Quests anzeigen",
        ["koKR"] = "레이드 퀘스트 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misiones de bandas",
        ["enUS"] = true,
        ["zhCN"] = "启用团队任务图标",
        ["zhTW"] = "團隊任務圖示",
        ["esES"] = "Habilitar iconos de misiones de bandas",
        ["frFR"] = "Icônes des quêtes de raid",
    },
    ["When this is enabled, the locations of raid quest will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando isso estiver ativado, os locais da missão da raide serão mostrados no mapa/minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения рейдовых заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von Raid-Quests auf der Karte/Minimap.",
        ["koKR"] = "아이콘을 활성화시, 레이드 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["esMX"] = "Si está marcado, la localización de misiones de bandas mostrará en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，团队任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "在世界地圖/小地圖上顯示可取得團隊任務的地點",
        ["esES"] = "Si está marcado, la localización de misiones de bandas mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes de raid sur la carte/mini-carte.",
    },
    ["Enable Dungeon Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões de masmorra",
        ["ruRU"] = "Значки заданий подземелий",
        ["deDE"] = "Dungeon-Quests anzeigen",
        ["koKR"] = "던전 퀘스트 활성화",
        ["esMX"] = "Habilitar iconos de misiones de calabozos",
        ["enUS"] = true,
        ["zhCN"] = "启用副本任务图标",
        ["zhTW"] = "副本任務圖示",
        ["esES"] = "Habilitar iconos de misiones de mazmorras",
        ["frFR"] = "Icônes des quêtes de donjon",
    },
    ["When this is enabled, the locations of dungeon quest will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando isso estiver ativado, os locais da missão da masmorra serão mostrados no mapa/minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения заданий подземелий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von Dungeon-Quests auf der Karte/Minimap.",
        ["koKR"] = "아이콘을 활성화시, 던전 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["esMX"] = "Si está marcado, la localización de misiones de calabozos mostrará en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，副本任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "在世界地圖/小地圖上顯示可取得副本任務的地點",
        ["esES"] = "Si está marcado, la localización de misiones de mazmorras mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes de donjon sur la carte/mini-carte.",
    },
    ["Enable Completed Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões concluídas",
        ["ruRU"] = "Значки выполненных заданий",
        ["deDE"] = "Icons zu abgeschlossenen Quests anzeigen",
        ["koKR"] = "퀘스트 완료 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misión completada",
        ["enUS"] = true,
        ["zhCN"] = "启用提交任务标记",
        ["zhTW"] = "回報任務標記",
        ["esES"] = "Habilitar iconos de misión completada",
        ["frFR"] = "Icônes des quêtes terminées",
    },
    ["Enable PvP Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões de JxJ",
        ["ruRU"] = "Значки PVP-заданий",
        ["deDE"] = "PvP-Quests anzeigen",
        ["koKR"] = "PVP 퀘스트 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misiones de JcJ",
        ["enUS"] = true,
        ["zhCN"] = "启用PVP任务图标",
        ["zhTW"] = "PvP任務圖示",
        ["esES"] = "Habilitar iconos de misiones de JcJ",
        ["frFR"] = "Icônes des quêtes JcJ",
    },
    ["When this is enabled, the locations of PvP quest will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando isso estiver ativado, os locais da missão de JxJ serão mostrados no mapa/minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения PvP-заданий на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons von PvP-Quests auf der Karte/Minimap.",
        ["koKR"] = "아이콘을 활성화시, PVP 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["esMX"] = "Si está marcado, la localización de misiones de JcJ mostrará en el mapa y minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，PVP任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "在世界地圖/小地圖上顯示可取得PvP任務的地點",
        ["esES"] = "Si está marcado, la localización de misiones de JcJ mostrará en el mapa y minimapa.",
        ["frFR"] = "Active l'affichage des quêtes JcJ sur la carte/mini-carte.",
    },
    ["Enable AQ War Effort Quest Icons"] = {
        ["ptBR"] = "Ativar ícones de missões de Guerra em Ahn'Qiraj",
        ["ruRU"] = "Значки военной кампании Ан'Киража",
        ["deDE"] = "AQ Kriegsanstrengungen Quests anzeigen",
        ["koKR"] = "안퀴라즈 반납 퀘스트 아이콘 활성화",
        ["esMX"] = "Habilitar iconos de misiones de la Guerra de Ahn'Qiraj",
        ["enUS"] = true,
        ["zhCN"] = "启用安其拉战备任务图标",
        ["zhTW"] = "啟用安其拉戰備任務圖示",
        ["esES"] = "Habilitar iconos de misiones de la Guerra de Ahn'Qiraj",
        ["frFR"] = "Icônes de l'Effort de guerre d'AQ",
    },
    ["When this is enabled, the locations of the AQ War Effort quest will be shown on the map/minimap."] = {
        ["ptBR"] = "Quando isso estiver ativado, os locais da missão de Guerra em Ahn'Qiraj serão mostrados no mapa/minimapa.",
        ["ruRU"] = "Показать/скрыть местоположения заданий военной кампании Ан'Киража на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert die Icons der AQ Kriegsanstrengungen Quests auf der Karte/Minimap.",
        ["koKR"] = "아이콘을 활성화시, 안퀴라즈 반납 퀘스트의 위치를 맵/미니맵에 표시합니다.",
        ["esMX"] = "Si está habilitado, las localizaciones de las misiones de la Guerra de Ahn'Qiraj mostrarán en el mapa/minimapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，安其拉战备任务的位置将显示在 世界地图/小地图上。",
        ["zhTW"] = "啟用此功能後，安其拉戰備任務的位置將顯示在世界地圖/小地圖上。",
        ["esES"] = "Si está habilitado, las localizaciones de las misiones de la Guerra de Ahn'Qiraj mostrarán en el mapa/minimapa.",
        ["frFR"] = "Active l'affichage des quêtes de l'Effort de guerre d'Ahn'Qiraj sur la carte/mini-carte.",
    },
    ["Enable Minimap Button"] = {
        ["ptBR"] = "Ative o botão da mini-carta",
        ["ruRU"] = "Кнопка у миникарты",
        ["deDE"] = "Minimap-Button aktivieren",
        ["koKR"] = "미니맵 버튼 활성화",
        ["esMX"] = "Habilitar icono del minimapa",
        ["enUS"] = true,
        ["zhCN"] = "启用Questie的小地图按钮",
        ["zhTW"] = "小地圖按鈕",
        ["esES"] = "Habilitar icono del minimapa",
        ["frFR"] = "Bouton autour de la mini-carte",
    },
    ["Enable or disable the Questie minimap button. You can still access the options menu with /questie."] = {
        ["ptBR"] = "Ative ou desative o botão da mini-carta da missão. Você ainda pode acessar o menu de opções com o Questie",
        ["ruRU"] = "Показать/скрыть кнопку Questie у миникарты. Доступ к настройкам аддона также можно получить через команду '/questie'",
        ["deDE"] = "Questie Minimap-Button aktivieren/deaktivieren. Mit /questie kannst du trotzdem die Einstellungen aufrufen.",
        ["koKR"] = "Questie 미니맵 버튼을 사용합니다. /questie 명령어로도 설정 메뉴를 열 수 있습니다.",
        ["esMX"] = "Habilita o deshabilita el icono del minimapa. Puedes seguir accediendo al menú de opciones con /questie",
        ["enUS"] = true,
        ["zhCN"] = "启用小地图按钮；禁用后以 /questie 打开配置",
        ["zhTW"] = "啟用/停用小地圖Questie按鈕。您可以輸入/questie以打開設定視窗",
        ["esES"] = "Habilita o deshabilita el icono del minimapa. Puedes seguir accediendo al menú de opciones con /questie",
        ["frFR"] = "Active le bouton Questie autour de la mini-carte. Le panneau de configuration reste accessible avec la commande /questie.",
    },
    ["Enable Instant Quest Text"] = {
        ["ptBR"] = "Ativar texto de pesquisa instantânea",
        ["ruRU"] = "Мгновенное отображение текста",
        ["deDE"] = "Questtext sofort anzeigen",
        ["koKR"] = "퀘스트 내용 바로 표시",
        ["esMX"] = "Habilitar el texto automático de misiones",
        ["enUS"] = true,
        ["zhCN"] = "立即显示任务文本",
        ["zhTW"] = "立刻顯示任務內容",
        ["esES"] = "Habilitar el texto automático de misiones",
        ["frFR"] = "Activer Texte instantané (quêtes)",
    },
    ["Toggles the default Instant Quest Text option. This is just a shortcut for the WoW option in Interface."] = {
        ["ptBR"] = "Ativa / desativa a opção Texto da missão instantânea. Este é apenas um atalho para a opção WoW na Interface",
        ["ruRU"] = "Включает мгновенное отображение полного текста заданий. Это всего лишь ярлык для стандартной опции в настройках интерфейса игры",
        ["deDE"] = "Die Standardeinstellung für 'Questtext sofort anzeigen' aktivieren/deaktivieren. Dies ist nur eine Abkürzung zum WoW-Interface-Menü.",
        ["koKR"] = "퀘스트 지문이 한번에 표시됩니다. 이 설정은 게임설정의 '퀘스트 내용 바로 표시'와 동일합니다.",
        ["esMX"] = "Habilita el texto automático de misiones. Es simplemente un atajo a la opción de la interfaz de WoW",
        ["enUS"] = true,
        ["zhCN"] = "使任务直接显示完整文本，这其实是一个暴雪原生自带的功能",
        ["zhTW"] = "使任務直接顯示完整內容。這其實是一個暴雪介面本身就有的功能：ESC > 介面設定 > 顯示 > 立刻顯示任務內容",
        ["esES"] = "Habilita el texto automático de misiones. Es simplemente un atajo a la opción de la interfaz de WoW",
        ["frFR"] = "Active l'option Texte instantané (quêtes). Cela revient à cocher l'option du même nom dans Interface/Affichage.",
    },
    ["Auto Accept Quests"] = {
        ["ptBR"] = "Aceitar automaticamente missões",
        ["ruRU"] = "Автопринятие заданий",
        ["deDE"] = "Quests automatisch annehmen",
        ["koKR"] = "자동 퀘스트 수락",
        ["esMX"] = "Aceptar misiones automáticamente",
        ["enUS"] = true,
        ["zhCN"] = "自动接受任务",
        ["zhTW"] = "自動接受任務",
        ["esES"] = "Aceptar misiones automáticamente",
        ["frFR"] = "Acceptation automatique des quêtes",
    },
    ["Enable or disable Questie auto-accepting quests."] = {
        ["ptBR"] = "Ativa ou desativa as missões de aceitação automática da Questie.",
        ["ruRU"] = "Включить/отключить автоматическое принятие заданий",
        ["deDE"] = "Aktiviert/Deaktiviert, ob Questie Quests automatisch annimmt.",
        ["koKR"] = "퀘스티 자동 퀘스트 수락을 할지 말지 선택합니다.",
        ["esMX"] = "Habilita o deshabilita aceptar misiones automáticamente.",
        ["enUS"] = true,
        ["zhCN"] = "启用后和NPC对话，自动接受任务。",
        ["zhTW"] = "與任務NPC交談後自動接受任務",
        ["esES"] = "Habilita o deshabilita aceptar misiones automáticamente.",
        ["frFR"] = "Active l'acceptation automatique des quêtes par Questie.",
    },
    ["Auto Complete"] = {
        ["ptBR"] = "Autocompletar",
        ["ruRU"] = "Автозавершение заданий",
        ["deDE"] = "Quests automatisch abgeben",
        ["koKR"] = "자동 완료",
        ["esMX"] = "Completar misiones automáticamente",
        ["enUS"] = true,
        ["zhCN"] = "自动完成",
        ["zhTW"] = "自動完成",
        ["esES"] = "Completar misiones automáticamente",
        ["frFR"] = "Complétion automatique",
    },
    ["Enable or disable Questie auto-complete quests."] = {
        ["ptBR"] = "Ative ou desative autocompletar missões.",
        ["ruRU"] = "Включить/отключить автоматическое завершение выполненных заданий",
        ["deDE"] = "Aktiviert/Deaktiviert, ob Questie Quests automatisch abgibt.",
        ["koKR"] = "퀘스트 자동 퀘스트 완료를 할지 말지 선택합니다.",
        ["esMX"] = "Habilita o deshabilita completar misiones automáticamente.",
        ["enUS"] = true,
        ["zhCN"] = "启用后和NPC交谈，自动完成。",
        ["zhTW"] = "完成任務並與指定任務NPC交談時，自動回報並完成任務",
        ["esES"] = "Habilita o deshabilita completar misiones automáticamente.",
        ["frFR"] = "Active/désactive la complétion automatique des quêtes par Questie.",
    },
    ["Enable Automatic NPC Dialog"] = {
        ["ptBR"] = "Ativar diálogo do NPC automática",
        ["ruRU"] = "Автодиалог с NPC",
        ["deDE"] = "NPC-Dialoge automatisieren",
        ["koKR"] = "자동 NPC 대화 활성화",
        ["esMX"] = "Habilitar el diálogo automático de PNJ",
        ["enUS"] = true,
        ["zhCN"] = "自动执行NPC对话",
        ["zhTW"] = "自動進行 NPC 對話",
        ["esES"] = "Habilitar el diálogo automático de PNJ",
        ["frFR"] = "Activation des dialogues PNJ automatiques",
    },
    ["Enable or disable Questie automatically advancing through NPC dialog."] = {
        ["ptBR"] = "Ativa ou desativa o Questie avançando automaticamente através da caixa de diálogo do NPC",
        ["ruRU"] = "Включить/отключить автоматическое ведение диалога с NPC",
        ["deDE"] = "Aktiviert/Deaktiviert, ob Questie Dialoge mit NPCs automatisch durchführt",
        ["koKR"] = "NPC 대화 상자를 통해 자동으로 진행 중인 Questie를 활성화 또는 비활성화합니다.",
        ["esMX"] = "Habilita o deshabilita que Questie avanza automáticamente a través del diálogo PNJ",
        ["enUS"] = true,
        ["zhCN"] = "启用或禁用Questie自动和NPC的对话框。",
        ["zhTW"] = "啟用或禁用 Questie 自動與 NPC 進行對話。",
        ["esES"] = "Habilita o deshabilita que Questie avanza automáticamente a través del diálogo PNJ",
        ["frFR"] = "Active/désactive l'avancement automatique des dialogues PNJ par Questie.",
    },
    ["Auto Modifier"] = {
        ["ptBR"] = "Edição automática",
        ["ruRU"] = "Авто-модификатор",
        ["deDE"] = "Auto Modifikator",
        ["koKR"] = "자동 수정",
        ["esMX"] = "Auto modificador",
        ["enUS"] = true,
        ["zhCN"] = "自动调整",
        ["zhTW"] = "自動調整",
        ["esES"] = "Auto modificador",
        ["frFR"] = "Modificateur Auto",
    },
    ["The modifier to NOT auto-accept/-complete quests when either option is enabled and you interact with a quest NPC."] = {
        ["ptBR"] = "O modificador para NÃO aceitar automaticamente / completar missões quando uma das opções está ativada e você interage com um PNJ de missão.",
        ["ruRU"] = "Клавиша, при зажатии которой автопринятие/автозавершение задания НЕ сработает при его принятии/завершении",
        ["deDE"] = "Die Taste, um Quests NICHT automatisch anzunehmen/abzugeben, wenn die jeweilige Einstellung aktiviert ist und mit einem Quest NPC interagiert wird.",
        ["koKR"] = "두 옵션 중 하나를 사용하고 사용자가 퀘스트 NPC와 상호 작용할 때 퀘스트를 자동 수락/완성하지 않음.",
        ["esMX"] = "El modificador para NO aceptar/completar automáticamente las misiones cuando cualquiera de las opciones está habilitada e interactúas con un asignador de misión.",
        ["enUS"] = true,
        ["zhCN"] = "当与NPC互动时，即便您已启用自动接受/自动完成，启用额外按键以触发对应功能.",
        ["zhTW"] = "當與NPC互動時，即便您已啟用自動接受/自動完成，啟用額外按鍵以觸發對應功能",
        ["esES"] = "El modificador para NO aceptar/completar automáticamente las misiones cuando cualquiera de las opciones está habilitada e interactúas con un asignador de misión.",
        ["frFR"] = "Le modificateur pour NE PAS accepter/compléter automatiquement une quête lorsque l'une de ces options est active et que vous interagissez avec un PNJ de quête.",
    },
    ["Accept trivial (low level) quests"] = {
        ["ptBR"] = "Aceitar missões triviais (nível baixo)",
        ["ruRU"] = "Автопринятие 'серых' заданий",
        ["deDE"] = "Triviale (niedrigstufige) Quests annehmen",
        ["koKR"] = "저레벨 퀘스트 수락",
        ["esMX"] = "Aceptar misiones triviales (de bajo nivel)",
        ["enUS"] = true,
        ["zhCN"] = "自动接受低级任务",
        ["zhTW"] = "接受低等級任務",
        ["esES"] = "Aceptar misiones triviales (de bajo nivel)",
        ["frFR"] = "Accepter les quêtes obsolètes (bas niveau)",
    },
    ["When this is enabled trivial (gray) quests will be auto accepted as well."] = {
        ["ptBR"] = "Quando isso estiver ativado, missões triviais (cinza) também serão aceitas automaticamente.",
        ["ruRU"] = "Включить/отключить автоматическое принятие низкоуровневых (серых) заданий",
        ["deDE"] = "Aktiviert/Deaktiviert, ob Questie triviale (graune) Quests automatisch annimmt.",
        ["koKR"] = "이 옵션을 선택하면 저레벨(회색) 퀘스트도 자동으로 수락됩니다.",
        ["esMX"] = "Si está habilitado, las misiones triviales (grises) también se aceptarán automáticamente.",
        ["enUS"] = true,
        ["zhCN"] = "启用此功能后，低级（灰色）的任务也会被自动接受。",
        ["zhTW"] = "低等級任務也自動被接受",
        ["esES"] = "Si está habilitado, las misiones triviales (grises) también se aceptarán automáticamente.",
        ["frFR"] = "Étend l'acceptation automatique aux quêtes obsolètes (grises).",
    },
    ["Quest Announce"] = {
        ["ptBR"] = "Anúncio de missão",
        ["ruRU"] = "Сообщить о задании",
        ["frFR"] = "Annonce de quête",
        ["koKR"] = "퀘스트 알림",
        ["enUS"] = true,
        ["zhCN"] = "任务进度通报",
        ["zhTW"] = "任務進度通報",
        ["deDE"] = "Quests mitteilen",
        ["esES"] = "Anuncio de misión",
        ["esMX"] = "Anuncio de misión",
    },
    ["Announce objective completion to party members"] = {
        ["ptBR"] = "Anuncia a conclusão do objetivo da missão aos membros do grupo",
        ["ruRU"] = "Сообщает о выполнении цели задания членам группы",
        ["frFR"] = "Annonce la réalisation de l'objectif aux membres du groupe",
        ["koKR"] = "파티원에게 퀘스트 완료 알림",
        ["enUS"] = true,
        ["zhCN"] = "向队员通报任务进度完成情况",
        ["zhTW"] = "向隊員通報任務進度完成狀況",
        ["deDE"] = "Teilt das Abschließen von Quests den Gruppenmitgliedern mit.",
        ["esES"] = "Anunciar la terminación de objetivos de misiones al miembros de grupo",
        ["esMX"] = "Anunciar la terminación de objetivos de misiones al miembros de grupo",
    },
    ["Share quest progress with nearby players"] = {
        ["ptBR"] = "Compartilhar o progresso da missão com jogadores próximos",
        ["ruRU"] = "Делиться прогрессом заданий",
        ["deDE"] = "Quest-Fortschritt mit Spielern in der Nähe teilen",
        ["koKR"] = "근처 플레이어에게 퀘스트 진행 공유",
        ["esMX"] = "Compartir el progreso de la misión con jugadores cercanos",
        ["enUS"] = true,
        ["zhCN"] = "与身边玩家分享任务进度",
        ["zhTW"] = "對鄰近玩家分享任務進度",
        ["esES"] = "Compartir el progreso de la misión con jugadores cercanos",
        ["frFR"] = "Partager la progression avec les joueurs proches",
    },
    ["Your quest progress will be periodically sent to nearby players. Disabling this doesn't affect sharing progress with party members."] = {
        ["ptBR"] = "O progresso da sua missão será enviado periodicamente a jogadores próximos",
        ["ruRU"] = "Прогресс ваших заданий будет периодически отправляться игрокам, находящимся рядом",
        ["deDE"] = "Sendet deinen Quests-Fortschritt regelmäßig zu nahegelegenen Spielern",
        ["koKR"] = "퀘스트 진행상황은 정기적으로 근처 플레이어로 전송됩니다. 이 기능을 사용하지 않도록 설정해도 파티원과의 진행률 공유에는 영향을 주지 않습니다.",
        ["esMX"] = "El progreso de tu misión se enviará periódicamente a los jugadores cercanos.",
        ["enUS"] = true,
        ["zhCN"] = "你的任务进度將定期的发送给身边玩家",
        ["zhTW"] = "你的任務進度將定期的傳送給鄰近玩家",
        ["esES"] = "El progreso de tu misión se enviará periódicamente a los jugadores cercanos.",
        ["frFR"] = "La progression de vos quêtes sera régulièrement partagée avec les joueurs proches.",
    },
    ["Quest Level Options"] = {
        ["ptBR"] = "Opções de nível de missão",
        ["ruRU"] = "Настройки уровней заданий",
        ["deDE"] = "Questlevel-Einstellungen",
        ["koKR"] = "퀘스트 레벨 설정",
        ["esMX"] = "Opciones para el nivel de las misiones",
        ["enUS"] = true,
        ["zhCN"] = "任务等级选项",
        ["zhTW"] = "任務等級選項",
        ["esES"] = "Opciones para el nivel de las misiones",
        ["frFR"] = "Options du niveau des quêtes",
    },
    ["Show All Quests below range (Low level quests)"] = {
        ["ptBR"] = "Veja todas as missões abaixo (missões de nível inferior)",
        ["ruRU"] = "Низкоуровневые задания",
        ["deDE"] = "Zeige niedrigstufige Quests",
        ["koKR"] = "범위를 벗어난 모든 퀘스트 표시 (저레벨 퀘스트 표시)",
        ["esMX"] = "Mostrar todas las misiones por debajo del rango (Misiones de bajo nivel)",
        ["enUS"] = true,
        ["zhCN"] = "显示所有低等级任务",
        ["zhTW"] = "顯示所有低等級任務",
        ["esES"] = "Mostrar todas las misiones por debajo del rango (Misiones de bajo nivel)",
        ["frFR"] = "Afficher toutes les quêtes obsolètes",
    },
    ["Enable or disable showing of showing low level quests on the map."] = {
        ["ptBR"] = "Ative ou desative a exibição das missões de baixo nível exibidas no mapa.",
        ["ruRU"] = "Показать/скрыть низкоуровневые (серые) задания на карте мира и миникарте",
        ["deDE"] = "Aktiviert/Deaktiviert niedrigstufige Quests auf der Karte",
        ["koKR"] = "퀘스트 표시 범위를 벗어난 저레벨 퀘스트도 모두 표시합니다.",
        ["esMX"] = "Habilita o deshabilita que se muestren misiones de bajo nivel en el mapa.",
        ["enUS"] = true,
        ["zhCN"] = "启用后，在地图上显示低等级任务。",
        ["zhTW"] = "在地圖上顯示低等級任務。",
        ["esES"] = "Habilita o deshabilita que se muestren misiones de bajo nivel en el mapa.",
        ["frFR"] = "Active l'affichage de toutes les quêtes vertes et grises sur la carte.",
    },
    ["Enable manual minimum level offset"] = {
        ["ptBR"] = "Ativar deslocamento de nível mínimo manual",
        ["ruRU"] = "Ручное смещение мин. уровня",
        ["deDE"] = "Manuelles Minimallevel aktivieren",
        ["koKR"] = "저레벨 퀘스트 표시 범위 활성화",
        ["esMX"] = "Habilitar compensación de nivel mínimo manual",
        ["enUS"] = true,
        ["zhCN"] = "启用自定义最小任务等级",
        ["zhTW"] = "自訂的最小任務等級平移值",
        ["esES"] = "Habilitar compensación de nivel mínimo manual",
        ["frFR"] = "Régler manuellement l'écart de niveaux inférieurs",
    },
    ["Enable manual minimum level offset instead of the automatic GetQuestGreenLevel function."] = {
        ["ptBR"] = "Ativa o deslocamento de nível mínimo manual em vez da função automática GetQuestGreenLevel.",
        ["ruRU"] = "Включить/отключить ручное смещение минимального уровня заданий вместо автоматической функции 'зеленые задания'",
        ["deDE"] = "Aktiviert/Deaktiviert das manuelle Setzen eines Minimallevels anstatt die GetQuestGreenLevel zu verwenden.",
        ["koKR"] = "저레벨 퀘스트 표시 범위를 활성화합니다. 해당 범위 내의 퀘스트는 적정 레벨 퀘스트로 간주되어 녹색으로 표시됩니다.",
        ["esMX"] = "Habilite la compensación de nivel mínimo manual en lugar de la función automática GetQuestGreenLevel.",
        ["enUS"] = true,
        ["zhCN"] = "启用自定义最小任务等级，而不是自动获取绿色任务等级的功能.",
        ["zhTW"] = "使用自訂的最小任務等級平移值，而不是使用GetQuestGreenLevel所得到的最低等級值",
        ["esES"] = "Habilite la compensación de nivel mínimo manual en lugar de la función automática GetQuestGreenLevel.",
        ["frFR"] = "Active le réglage manuel de l'écart maximal entre le niveau des quêtes de niveaux inférieurs et le votre. Par défaut toutes les quêtes vertes seront affichées et toutes les grises seront cachées.",
    },
    ["< Show below level"] = {
        ["ptBR"] = "<Mostrar o nível abaixo do nível>",
        ["ruRU"] = "Ниже вашего уровня",
        ["deDE"] = "< Zeige unter Level",
        ["koKR"] = "< 저레벨 퀘스트 표시 범위",
        ["esMX"] = "< Niveles por debajo",
        ["enUS"] = true,
        ["zhCN"] = "< 低于等级",
        ["zhTW"] = "< 低於等級",
        ["esES"] = "< Niveles por debajo",
        ["frFR"] = "< Afficher sous le niveau",
    },
    ["How many levels below your character to show. ( Default: %s )"] = {
        ["ptBR"] = "Quantos níveis sobre o seu personagem para exibir. (Por defeito: %s",
        ["ruRU"] = "Отображение заданий, у которых уровень ниже, чем ваш уровень, на выбранное значение (по умолчанию: %s)",
        ["deDE"] = "Quests bis X Level unter deinem eigenen anzeigen. ( Standard: %s )",
        ["koKR"] = "현재 레벨보다 얼마나 낮은 퀘스트까지 표시할지 설정합니다. ( 기본값: %s )",
        ["esMX"] = "Cuantos niveles por debajo de tu personaje. ( Por defecto: %s )",
        ["enUS"] = true,
        ["zhCN"] = "显示比你低了多少级的任务（默认：%s）",
        ["zhTW"] = "顯示比你低了多少級的任務（預設：%s）",
        ["esES"] = "Cuantos niveles por debajo de tu personaje. ( Por defecto: %s )",
        ["frFR"] = "Définis l'écart maximal entre le niveau des quêtes et celui du joueur. (Par défaut : %s)",
    },
    ["Level from"] = {
        ["ptBR"] = "De Nível",
        ["ruRU"] = "Уровень от",
        ["deDE"] = "Level ab",
        ["koKR"] = "Level from",
        ["esMX"] = "De nivel",
        ["enUS"] = true,
        ["zhCN"] = "等级从",
        ["zhTW"] = "等級從",
        ["esES"] = "De nivel",
        ["frFR"] = "Du niveau :",
    },
    ["Minimum quest level to show."] = {
        ["ptBR"] = "Nível mínimo de missão para mostrar.",
        ["ruRU"] = "Минимальный уровень заданий для отображения",
        ["deDE"] = "Zeige Quests ab dem eingestellten Level.",
        ["koKR"] = "표시하는 최소 퀘스트 레벨",
        ["esMX"] = "Nivel mínimo de misión para mostrar.",
        ["enUS"] = true,
        ["zhCN"] = "显示最低任务等级。",
        ["zhTW"] = "顯示的最低任務等級",
        ["esES"] = "Nivel mínimo de misión para mostrar.",
        ["frFR"] = "Niveau minimum des quêtes à afficher.",
    },
    ["Level to"] = {
        ["ptBR"] = "Para Nível",
        ["ruRU"] = "Уровень до",
        ["deDE"] = "Level bis",
        ["koKR"] = "Level to",
        ["esMX"] = "A nivel",
        ["enUS"] = true,
        ["zhCN"] = "到等级",
        ["zhTW"] = "到等級",
        ["esES"] = "A nivel",
        ["frFR"] = "Au niveau :",
    },
    ["Maximum quest level to show."] = {
        ["ptBR"] = "Nível máximo de missões para mostrar.",
        ["ruRU"] = "Максимальный уровень заданий для отображения",
        ["deDE"] = "Zeige Quests bis zu dem eingestellten Level.",
        ["koKR"] = "표시하는 최고 퀘스트 레벨",
        ["esMX"] = "Máximo nivel de misión para mostrar.",
        ["enUS"] = true,
        ["zhCN"] = "显示最高任务等级",
        ["zhTW"] = "顯示的最高任務等級",
        ["esES"] = "Máximo nivel de misión para mostrar.",
        ["frFR"] = "Niveau maximum des quêtes à afficher.",
    },
    ["Enable absolute level range"] = {
        ["ptBR"] = "Ativar faixa de nível absoluto",
        ["ruRU"] = "Ручной диапазон",
        ["deDE"] = "Absolute Levelbegrenzung aktivieren",
        ["koKR"] = "Level 범위 표시",
        ["esMX"] = "Habilitar rango de nivel absoluto",
        ["enUS"] = true,
        ["zhCN"] = "任务等级范围",
        ["zhTW"] = "絕對任務等級範圍",
        ["esES"] = "Habilitar rango de nivel absoluto",
        ["frFR"] = "Utiliser l'écart absolu",
    },
    ["Change the level offset to absolute level values."] = {
        ["ptBR"] = "Altere o deslocamento do nível para valores de nível absolutos.",
        ["ruRU"] = "Ручной выбор уровня отображаемых заданий",
        ["deDE"] = "Ändert die relative Levelbegrenzung zu einem absoluten Start- und Endwert.",
        ["koKR"] = "Level 오프셋을 절대 Level 값으로 변경합니다.",
        ["esMX"] = "Cambia la compensación de nivel a valores de nivel absoluto.",
        ["enUS"] = true,
        ["zhCN"] = "变更任务等级平均值成绝对任务等级范围值。",
        ["zhTW"] = "變更任務等級平移值成絕對任務等級範圍值",
        ["esES"] = "Cambia la compensación de nivel a valores de nivel absoluto.",
        ["frFR"] = "Remlace l'écart de niveau par des valeurs absolues et affiche toutes les quêtes comprises entre les niveaux X et le niveau Y.",
    },
    ["Objective icon cluster amount"] = {
        ["ptBR"] = "Quantidade de ícones de objetivos",
        ["ruRU"] = "Группировка значков",
        ["deDE"] = "Ziel-Icon-Cluster-Menge",
        ["koKR"] = "퀘스트 목표 아이콘 합치기",
        ["esMX"] = "Cantidad de objetivos a agrupar",
        ["enUS"] = true,
        ["zhCN"] = "任务目标密度",
        ["zhTW"] = "任務目標密度",
        ["esES"] = "Cantidad de objetivos a agrupar",
        ["frFR"] = "Fusion des icônes des objectifs",
    },
    ["How much objective icons should cluster."] = {
        ["ptBR"] = "Quantos ícones de objetivos devem ser agrupados.",
        ["ruRU"] = "Установка количества значков целей, при котором значки будут группироваться",
        ["deDE"] = "Wie viele Ziel-Icons in einem Cluster gezeigt werden sollen.",
        ["koKR"] = "퀘스트 목표 아이콘을 몇개까지 합쳐서 보여줄지 설정합니다.",
        ["esMX"] = "Cuántos iconos de objetivo deberian agruparse.",
        ["enUS"] = true,
        ["zhCN"] = "目标图标代表多少怪",
        ["zhTW"] = "目標圖示代表多少怪",
        ["esES"] = "Cuántos iconos de objetivo deberian agruparse.",
        ["frFR"] = "Définis le nombre d'icônes des objectifs proches les unes des autres à fusionner.",
    },
}

for k, v in pairs(generalOptionsLocales) do
    l10n.translations[k] = v
end
